<!DOCTYPE html>
<html lang="ru">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <meta http-equiv="X-UA-Compatible" content="ie=edge" />
        <meta property="og:type" content="article" />
        <meta property="og:title" content="Auto.KIM Автокилимки та аксесуари преміум якості" />
        <meta property="og:site_name" content="KIM" />
        <meta property="og:url" content="https://auto.kim.kiev.ua/eva/" />
        <meta property="og:description" content="Auto.KIM - сертифіковані автокилимки від виробника №1 в Україні." />

        <meta property="og:image" content="https://auto.kim.kiev.ua/eva/images/og/auto_kim_1280x1280.jpg" />
        <meta property="og:image" content="https://auto.kim.kiev.ua/eva/images/og/auto_kim_mini.jpg" />
        <meta property="og:image" content="https://auto.kim.kiev.ua/eva/images/og/auto_kim_1280x1280.jpg" />

        <title>Політика безпеки</title>

        <meta name="keywords" content="Купити EVA килимки, Купити ЄВА килимки, купити ева килимки, коврики ева, килимки EVA, коврики ева"/>
        <meta name="description" content="Купити EVA килимки від виробника">

        <link rel="canonical" href="https://auto.kim.kiev.ua/eva">
        <link rel="icon" type="image/png" href="images/favicon.png">

        <!-- magnific popup -->
        <link rel="stylesheet" type="text/css" href="css/magnific-popup.css" />

        <!-- Boxicon -->
        <link rel="stylesheet" type="text/css" href="css/boxicons.min.css" />

        <!-- css -->
        <link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <link href="css/style.css" id="app-css" rel="stylesheet" type="text/css" />

        <!-- Google Tag Manager -->
        <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
        new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
        j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
        'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
        })(window,document,'script','dataLayer','GTM-TL25RKR');</script>
        <!-- End Google Tag Manager -->

        <!-- Global site tag (gtag.js) - Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=UA-193644420-1"></script>
        <script>
          window.dataLayer = window.dataLayer || [];
          function gtag(){dataLayer.push(arguments);}
          gtag('js', new Date());

          gtag('config', 'UA-193644420-1');
        </script>
        <!-- Global site tag (gtag.js) - Google Analytics -->

        <!-- Facebook Pixel Code -->
        <script>
          !function(f,b,e,v,n,t,s)
          {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
          n.callMethod.apply(n,arguments):n.queue.push(arguments)};
          if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
          n.queue=[];t=b.createElement(e);t.async=!0;
          t.src=v;s=b.getElementsByTagName(e)[0];
          s.parentNode.insertBefore(t,s)}(window, document,'script',
          'https://connect.facebook.net/en_US/fbevents.js');
          fbq('init', '243276697390053');
          fbq('track', 'PageView');
        </script>
        <noscript><img height="1" width="1" style="display:none"
          src="https://www.facebook.com/tr?id=243276697390053&ev=PageView&noscript=1"
        /></noscript>
        <!-- End Facebook Pixel Code -->         
    </head>

    <body>
        <!-- Google Tag Manager (noscript) -->
        <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-TL25RKR"
        height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
        <!-- End Google Tag Manager (noscript) -->
        
        <!-- Start navbar -->
        <nav class="navbar navbar-expand-lg navbar-light fixed-top sticky">
            <div class="container">
                <a class="navbar-brand" href="https://auto.kim.kiev.ua/eva">
                    <img src="images/logo_auto_black.png" class="logo-dark" alt="logo" height="50" />
                </a>
                <a href="#" class="navbar-toggler" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggle-icon"><i class="bx bx-menu"></i></span>
                </a>

                <div class="collapse navbar-collapse" id="navbarNav">
                    <ul class="navbar-nav ml-auto">
                        <li class="nav-item">
                            <div class="dropdown">
                                <a class="nav-link" id="dropPhone" data-toggle="dropdown" href="#"><i class="bx bx-phone align-middle font-size-23 icon ml-1"></i><i class="bx bx-chevron-down align-middle font-size-18"></i></a>
                                <div class="dropdown-menu" aria-labelledby="dropPhone">
                                    <a class="dropdown-item" href="tel:+380932637959">093 263 79 59</a>
                                </div>
                            </div>  
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="index.php">На головну</a>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>
        <!-- end navbar -->

        <!-- start Приветствие -->
        <section class="hero-3 position-relative" id="hello" style="background-image: url(images/hero-3-bg.jpg);">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="hero-content">
                            <h1 class="font-weight-semibold hero-title my-4 pb-2">Політика безпеки</h1>
                            Ми збираємо Ваші дані, щоб наші менеджери змогли зв'язатися з Вами для уточнення деталей замовлення
                            <p class="text-uppercase mt-5"><b>Номер телефону та ПІБ</b></p>
                            Номер використовується тільки для підтвердження замовлення, яке ви здійснили, а також подяки за покупку продуктів. У компанії заборонені нав'язливі телефонні продажі та розсилання спаму на пошту. Якщо ви вирішили надати нам чужі дані – обов'язково отримаєте дозвіл у відповідних осіб
                            <p class="text-uppercase mt-5"><b>Обробка даних</b></p>
                            Ми використовуємо ваші дані для: — Надсилання службових повідомлень про статус виконання замовлення — Розсилки новин та рекламної інформації про спеціальні пропозиції
                            <p class="text-uppercase mt-5"><b>Хто отримує доступ до даних</b></p>
                            Для поштових розсилок ми використовуємо сервіс, призначений для цього. Він обробляє персональну інформацію, щоб вчасно та в повному обсязі доставляти вам листи
                            <p class="text-uppercase mt-5"><b>Діти</b></p>
                            Ми не збираємо інформацію про дітей навмисно. Коли дізнаємося, що отримали персональну інформацію про дитину, яка не досягла 14-річного віку, — видалимо. Якщо вам менше 18 років, обов'язково отримайте дозвіл батьків або опікунів, перш ніж надавати контактні дані
                            <p class="text-uppercase mt-5"><b>Відмова від підписки</b></p>
                            Щоб відмовитись від розсилки — перейдіть за посиланням «Відписатися» наприкінці будь-якого листа
                            <p class="text-uppercase mt-5"><b>Питання та проблеми</b></p>
                            Якщо виникнуть питання/проблеми, пов'язані з безпекою та безпекою персональних даних — пишіть нам на dir@auto.kim.kiev.ua
                            <p class="text-uppercase mt-5"><b>Безпека</b></p>
                            Ми регулярно дбаємо про те, щоб звести до мінімуму можливість втрати, крадіжки, знищення, зміни, розкриття чи будь-якого іншого несумлінного використання вашої персональної інформації. Але гарантувати абсолютне усунення ризику неможливо. Тому рекомендуємо надійно зберігати паролі до облікових записів, а якщо стане відомо про порушення інформаційної безпеки — повідомляти нам у найкоротший термін
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- end Приветствие -->

        <!-- start footer -->
        <footer class="footer bg-light" id="contacts">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-3 mt-sm-0 mt-5">
                        <a href="#" class="footer-logo">
                            <img src="images/logo_auto_black.png" class="logo-dark" alt="" height="50" />
                        </a>
                        <p class="text-muted mt-4 pt-2">Автоковрики та аксесуари преміум якості<br><span class="text-primary">від виробника №1 в Україні</span></p>
                        <a href="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d635.2860971218674!2d30.62233172920176!3d50.43841115287661!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zNTDCsDI2JzE4LjMiTiAzMMKwMzcnMjIuNCJF!5e0!3m2!1sru!2sua!4v1616597903213!5m2!1sru!2sua" class="google-map btn btn-white mt-3 map-hover">
                            <i class="bx bx-map-pin icon font-size-18 align-middle mr-1"></i>Подивитись на карті
                        </a>
                    </div>
                    <div class="col lg-1"></div>
                    <div class="col-lg-2 col-md-3 mt-sm-0 mt-5">
                        <h4 class="font-size-18 mb-0">Мапа сайту</h4>
                        <ul class="list-unstyled mt-4 mb-0">
                            <li class="py-1">
                                <a href="#hello">
                                    <i class="bx bx-git-commit align-middle text-primary icon font-size-18 mr-2"></i>
                                    Вітання
                                </a>
                            </li>
                            <li class="py-1">
                                <a href="#whyeva">
                                    <i class="bx bx-git-commit align-middle text-primary icon font-size-18 mr-2"></i>
                                    Переваги
                                </a>
                            </li>
                            <li class="py-1">
                                <a href="#sravnite">
                                    <i class="bx bx-git-commit align-middle text-primary icon font-size-18 mr-2"></i>
                                    Порівняння
                                </a>
                            </li>
                            <li class="py-1">
                                <a href="#portfolio">
                                    <i class="bx bx-git-commit align-middle text-primary icon font-size-18 mr-2"></i>
                                    Фото рабіт
                                </a>
                            </li>
                            <li class="py-1">
                                <a href="#shop">
                                    <i class="bx bx-git-commit align-middle text-primary icon font-size-18 mr-2"></i>
                                    Магазин
                                </a>
                            </li>
                            <li class="py-1">
                                <a href="#order-form">
                                    <i class="bx bx-git-commit align-middle text-primary icon font-size-18 mr-2"></i>
                                    Замовити
                                </a>
                            </li>
                        </ul>
                    </div>
                    <div class="col-lg-3 col-md-3 mt-sm-0 mt-5">
                        <h4 class="font-size-18 mb-0">Графік роботи</h4>
                        <ul class="list-unstyled mt-4 mb-0">
                            <li class="py-1">
                                <span class="text-muted"><i class="bx bx-time align-middle text-primary icon font-size-18 mr-2"></i> Пн-Пт: з 9:00 до 21:00</span>
                            </li>
                            <li class="py-1">
                                <span class="text-muted"><i class="bx bx-time align-middle text-primary icon font-size-18 mr-2"></i> Сб-Нд: з 12:00 до 18:00</span>
                            </li>
                        </ul>
                    </div>
                    <div class="col-lg-3 col-md-3 mt-sm-0 mt-5">
                        <h4 class="font-size-18 mb-0">Контакти</h4>
                        <ul class="list-unstyled mt-4 mb-0">
                            <li class="py-1">
                                <a href="tel:+380932637959"><i class="bx bx-phone align-middle text-primary icon font-size-18 mr-2"></i> 093 263 79 59</a>
                            </li>
                            <li class="py-1">
                                <span class="text-muted"><i class="bx bx-map align-middle text-primary icon font-size-18 mr-2"></i> м.Київ, вул.Регенераторна, 4</span>
                                <!-- <a href="#"><i class="bx bx-map align-middle text-primary icon font-size-18 mr-2"></i> г.Киев, ул.Регенераторная, 4</a> -->
                            </li>
                            <li class="py-1">
                                <a href="mailto:dir@auto.kim.kiev.ua">
                                    <i class="bx bx-mail-send align-middle text-primary icon font-size-18 mr-2"></i>
                                    dir@auto.kim.kiev.ua
                                </a>
                            </li>
                            <li class="py-1">
                                <a href="https://auto.kim.kiev.ua">
                                    <i class="bx bx-world align-middle text-primary icon font-size-18 mr-2"></i>
                                    auto.kim.kiev.ua
                                </a>
                            </li>
                            <li class="py-1 mt-1">
                                <a href="https://www.instagram.com/auto.kim.kiev.ua/">
                                    <img src="images/inst1new.png" alt="instagram" class="rounded">
                                    <img src="images/inst0new.png" alt="instagram" class="rounded img-hover-inst">
                                </a>
                                <a href="https://facebook.com/auto.kim.kiev.ua/" class="ml-2">
                                    <img src="images/fb1new.png" alt="facebook" class="rounded">
                                    <img src="images/fb0new.png" alt="facebook" class="rounded img-hover-fb">
                                </a>
                            </li>
                            <li>
                                <br>
                                <i class="bx bx-list-check align-middle text-primary icon font-size-18 mr-2"></i>
                                <a href="terms.php">Умови угоди</a>
                            </li>
                            <li>
                                <i class="bx bx-shield align-middle text-primary icon font-size-18 mr-2"></i>
                                <a href="privacy.php">Політика безпеки</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </footer>
        <!-- end footer -->

        <!-- start footer alter -->
        <div class="footer-alt bg-primary">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="py-4">
                            <p class="text-white text-center mb-0">2021 © auto.kim. Design By Kim</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- end footer alter -->

        <script src="js/jquery-3.5.1.min.js"></script>
        <script src="js/bootstrap.bundle.min.js"></script>

        <!-- smooth link -->
        <script src="js/scrollspy.min.js"></script>
        <script src="js/jquery.easing.min.js"></script>

        <!-- magnific popup -->
        <script src="js/jquery.magnific-popup.min.js"></script>
        <script src="js/magnific.init.js"></script>

        <script src="js/app.js"></script>
    </body>
</html>
